# LuckysCloud Billing & Automation Panel

A custom WHMCS-like billing and web hosting automation panel built with **Laravel 11**.

## 🚀 Features

- **Storefront**: Modern landing page with dynamic pricing.
- **Client Area**:
    - Dashboard with service stats.
    - **One-click cPanel Login** (SSO via WHM API).
    - Invoice management & PDF downloads.
    - **Razorpay Integration** for payments.
- **Admin Panel**:
    - Manage Products (Hosting Plans).
    - View Clients & Orders.
    - Revenue Statistics.
- **Automation**:
    - **Auto-Provisioning**: Accounts created instantly via WHM upon payment.
    - **Auto-Suspension**: Overdue services suspended automatically via Cron.

## 🛠️ Tech Stack

- **Framework**: Laravel 11
- **Database**: MySQL 8.0
- **Frontend**: Blade Templates + Tailwind CSS (Breeze)
- **Queue**: Redis / Database (Supervisor)
- **Integrations**: Razorpay API, cPanel/WHM API

## ⚙️ Installation

### 1. Requirements
- PHP 8.2+
- Composer
- Node.js & NPM

### 2. Setup
```bash
# Install dependencies
composer install
npm install && npm run build

# Configure Environment
cp .env.example .env
php artisan key:generate
```

### 3. Database
Configure `DB_*` in `.env` and run migrations:
```bash
php artisan migrate --seed
```

### 4. Configuration
Set the following keys in `.env` for automation to work:
```env
# Razorpay
RAZORPAY_KEY=rzp_test_...
RAZORPAY_SECRET=...

# WHM / cPanel
WHM_URL=https://server.luckyscloud.in:2087
WHM_USERNAME=root
WHM_TOKEN=...
```

### 5. Deployment
Refer to [DEPLOYMENT.md](DEPLOYMENT.md) for detailed cPanel/VPS deployment instructions.

## 📝 License
Proprietary software for LuckysCloud.
