<?php

namespace App\Http\Controllers\Client;

use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;

class DashboardController extends Controller
{
    public function index()
    {
        $client = Auth::user();

        // Safety check if relationship exists (though we added it)
        if (!method_exists($client, 'services')) {
            return abort(500, 'User model missing services relationship.');
        }

        $activeServices = $client->services()->where('status', 'active')->count();
        $unpaidInvoices = $client->invoices()->where('status', 'unpaid')->count();

        $recentServices = $client->services()->latest()->take(5)->get();
        $recentInvoices = $client->invoices()->latest()->take(5)->get();

        return view('client.dashboard', compact('activeServices', 'unpaidInvoices', 'recentServices', 'recentInvoices'));
    }

    public function services()
    {
        $services = Auth::user()->services()->paginate(10);
        return view('client.services.index', compact('services'));
    }

    public function showService($id)
    {
        $service = Auth::user()->services()->findOrFail($id);
        return view('client.services.show', compact('service'));
    }
}
