<?php

namespace App\Http\Controllers\Client;

use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;
use PDF; // Assuming barryvdh/laravel-dompdf for PDF generation

class InvoiceController extends Controller
{
    public function index()
    {
        $invoices = Auth::user()->invoices()->latest()->paginate(10);
        return view('client.invoices.index', compact('invoices'));
    }

    public function show($id)
    {
        $invoice = Auth::user()->invoices()->with('items')->findOrFail($id);
        return view('client.invoices.show', compact('invoice'));
    }

    public function download($id)
    {
        $invoice = Auth::user()->invoices()->with('items')->findOrFail($id);
        $pdf = PDF::loadView('invoices.pdf', compact('invoice'));
        return $pdf->download('invoice-' . $invoice->invoice_number . '.pdf');
    }
}
