<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Log;
use App\Models\Order;
use App\Models\Transaction;

class RazorpayWebhookController extends Controller
{
    public function handle(Request $request)
    {
        $payload = $request->all();
        $signature = $request->header('X-Razorpay-Signature');

        // Verify signature secret here (crucial for security)
        // $this->verifySignature($request->getContent(), $signature);

        Log::info("Razorpay Webhook: ", $payload);

        if (($payload['event'] ?? '') == 'payment.captured') {
            $paymentId = $payload['payload']['payment']['entity']['id'];
            $orderId = $payload['payload']['payment']['entity']['order_id']; // This is Razorpay Order ID
            $amount = $payload['payload']['payment']['entity']['amount'] / 100;

            $order = Order::where('transaction_id', $orderId)->first();

            if ($order && $order->status !== 'active') {
                $order->update(['status' => 'active']);

                // Log Transaction
                Transaction::create([
                    'client_id' => $order->client_id,
                    'invoice_id' => $order->invoice->id ?? 0, // Handle optional invoice logic
                    'gateway' => 'razorpay',
                    'transaction_id' => $paymentId,
                    'amount_in' => $amount,
                    'description' => "Webhook Payment for Order #{$order->id}"
                ]);

                \App\Jobs\CreateHostingAccount::dispatch($order);
            }
        }

        return response()->json(['status' => 'ok']);
    }
}
