<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\Response;

class CheckInstalled
{
    /**
     * Handle an incoming request.
     *
     * @param  \Closure(\Illuminate\Http\Request): (\Symfony\Component\HttpFoundation\Response)  $next
     */
    public function handle(Request $request, Closure $next): Response
    {
        // Check if installed.lock exists
        $isInstalled = file_exists(storage_path('installed.lock'));

        // If installed, block access to installer routes
        if ($isInstalled) {
            if ($request->is('install') || $request->is('install/*')) {
                return redirect('/');
            }
        }
        // If NOT installed, force redirect to installer (except for installer routes)
        else {
            if (!$request->is('install') && !$request->is('install/*')) {
                return redirect('/install');
            }
        }

        return $next($request);
    }
}
