<?php

namespace App\Jobs;

use App\Models\Order;
use App\Models\Service;
use App\Services\Provisioning\WhmService;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Str;

class CreateHostingAccount implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    protected $order;

    public function __construct(Order $order)
    {
        $this->order = $order;
    }

    public function handle(WhmService $whmService)
    {
        Log::info("Starting provisioning for Order #{$this->order->id}");

        try {
            $client = $this->order->client;

            // Assuming single product order for MVP
            // In real app, loop through order items
            $product = \App\Models\Product::find(1); // Placeholder logic, should come from order items

            // Generate unique username & password
            $username = 'u' . $client->id . strtolower(Str::random(5)); // e.g., u1abcde
            $password = Str::random(12);

            // Call WHM API
            $result = $whmService->createAccount([
                'username' => $username,
                'domain' => $this->order->ip_address ?? $username . '.com', // Placeholder domain logic
                'password' => $password,
                'package_name' => $product->whm_package_name ?? 'default',
                'email' => $client->email,
            ]);

            // Create Service Record
            Service::create([
                'client_id' => $client->id,
                'order_id' => $this->order->id,
                'product_id' => $product->id ?? 1,
                'domain' => $result['options']['domain'] ?? $username . '.com',
                'username' => $username,
                'password' => $password, // Model casts will encrypt this
                'status' => 'active',
                'billing_cycle' => 'monthly',
                'next_due_date' => now()->addMonth(),
                'recurring_amount' => $product->monthly_price ?? 0,
            ]);

            Log::info("Provisioning successful for Order #{$this->order->id}");

        } catch (\Exception $e) {
            Log::error("Provisioning failed for Order #{$this->order->id}: " . $e->getMessage());
            $this->fail($e);
        }
    }
}
