<?php

namespace App\Jobs;

use App\Models\Service;
use App\Services\Provisioning\WhmService;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;
use Illuminate\Support\Facades\Log;

class SuspendOverdueServices implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    public function handle(WhmService $whmService)
    {
        $overdueServices = Service::where('status', 'active')
            ->where('next_due_date', '<', now()->subDays(5)) // 5 days grace period
            ->get();

        foreach ($overdueServices as $service) {
            try {
                $whmService->suspendAccount($service->username, 'Overdue Payment');

                $service->update([
                    'status' => 'suspended',
                    'suspend_reason' => 'Overdue Payment'
                ]);

                Log::info("Suspended Service #{$service->id} ({$service->domain})");

            } catch (\Exception $e) {
                Log::error("Failed to suspend Service #{$service->id}: " . $e->getMessage());
            }
        }
    }
}
