<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Order extends Model
{
    use HasFactory;

    protected $fillable = [
        'client_id',
        'amount',
        'payment_method',
        'status',
        'transaction_id',
        'ip_address'
    ];

    protected $casts = [
        'amount' => 'decimal:2',
    ];

    public function client()
    {
        return $this->belongsTo(Client::class);
    }
    public function invoice()
    {
        return $this->hasOne(Invoice::class);
    }
    public function services()
    {
        return $this->hasMany(Service::class);
    }
}
