<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Product extends Model
{
    use HasFactory;

    protected $fillable = [
        'name',
        'description',
        'monthly_price',
        'annual_price',
        'whm_package_name',
        'server_group_id',
        'is_hidden',
        'sort_order'
    ];

    protected $casts = [
        'monthly_price' => 'decimal:2',
        'annual_price' => 'decimal:2',
        'is_hidden' => 'boolean',
    ];

    public function services()
    {
        return $this->hasMany(Service::class);
    }
}
