<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\Crypt;

class Server extends Model
{
    use HasFactory;

    protected $fillable = [
        'name',
        'hostname',
        'ip_address',
        'whm_user',
        'whm_token',
        'max_accounts',
        'active'
    ];

    protected $casts = [
        'active' => 'boolean',
        'whm_token' => 'encrypted', // Laravel 11 encrypted cast
    ];

    public function services()
    {
        return $this->hasMany(Service::class);
    }
}
