<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\Crypt;

class Service extends Model
{
    use HasFactory;

    protected $fillable = [
        'tenant_id', // SaaS
        'user_id',   // Owned by User
        'order_id',
        'product_id',
        'server_id',
        'domain',
        'username',
        'password',
        'billing_cycle',
        'recurring_amount',
        'next_due_date',
        'status',
        'suspend_reason',
        'suspended_at',
        'terminated_at'
    ];

    protected $casts = [
        'next_due_date' => 'date',
        'suspended_at' => 'datetime',
        'terminated_at' => 'datetime',
        'recurring_amount' => 'decimal:2',
    ];

    // Automatically encrypt/decrypt password
    protected function password(): \Illuminate\Database\Eloquent\Casts\Attribute
    {
        return \Illuminate\Database\Eloquent\Casts\Attribute::make(
            get: fn($value) => $value ? Crypt::decryptString($value) : null,
            set: fn($value) => $value ? Crypt::encryptString($value) : null,
        );
    }

    public function user()
    {
        return $this->belongsTo(User::class);
    }

    public function tenant()
    {
        // Assuming Tenant model exists or will exist in App\Models\Tenant
        return $this->belongsTo(Tenant::class);
    }

    public function product()
    {
        return $this->belongsTo(Product::class);
    }

    public function server()
    {
        return $this->belongsTo(Server::class);
    }
}
