<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Transaction extends Model
{
    use HasFactory;

    protected $fillable = [
        'client_id',
        'invoice_id',
        'gateway',
        'transaction_id',
        'amount_in',
        'amount_out',
        'description'
    ];

    protected $casts = [
        'amount_in' => 'decimal:2',
        'amount_out' => 'decimal:2',
    ];

    public function client()
    {
        return $this->belongsTo(Client::class);
    }
    public function invoice()
    {
        return $this->belongsTo(Invoice::class);
    }
}
