<?php

namespace App\Providers;

use Illuminate\Support\ServiceProvider;

class AppServiceProvider extends ServiceProvider
{
    /**
     * Register any application services.
     */
    public function register(): void
    {
        // Shared Hosting Fix: If we are running inside 'core' folder, bind public path to root
        // This ensures asset() and vite() helpers look in public_html, not core/public
        if (str_contains(base_path(), '/core')) {
            $this->app->bind('path.public', function () {
                return realpath(base_path('../'));
            });
        }
    }

    /**
     * Bootstrap any application services.
     */
    public function boot(): void
    {
        //
    }
}
