<?php

namespace App\Services\Payment;

use Razorpay\Api\Api;
use Exception;
use Illuminate\Support\Facades\Log;

class RazorpayService
{
    protected $api;

    public function __construct()
    {
        $key = config('services.razorpay.key');
        $secret = config('services.razorpay.secret');

        if (!$key || !$secret) {
            Log::warning("Razorpay credentials missing from config.");
            return;
        }

        $this->api = new Api($key, $secret);
    }

    public function createOrder($amount, $receiptId)
    {
        try {
            // Amount in paise
            return $this->api->order->create([
                'receipt' => (string) $receiptId,
                'amount' => $amount * 100,
                'currency' => 'INR',
                'payment_capture' => 1
            ]);
        } catch (Exception $e) {
            Log::error("Razorpay Order Creation Failed: " . $e->getMessage());
            throw $e;
        }
    }

    public function verifyPaymentSignature($attributes)
    {
        try {
            $this->api->utility->verifyPaymentSignature($attributes);
            return true;
        } catch (Exception $e) {
            Log::error("Razorpay Signature Verification Failed: " . $e->getMessage());
            return false;
        }
    }

    public function fetchOrder($orderId)
    {
        return $this->api->order->fetch($orderId);
    }
}
