<?php

namespace Database\Seeders;

use App\Models\Product;
use App\Models\Service;
use App\Models\User;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;

class ServiceSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $user = User::first();
        $product = Product::first();

        if ($user && $product) {
            Service::create([
                'user_id' => $user->id,
                'product_id' => $product->id,
                'domain' => 'test-service.luckyscloud.in',
                'username' => 'testuser',
                'password' => 'secret123', // Will be encrypted by model cast
                'billing_cycle' => 'monthly',
                'recurring_amount' => $product->monthly_price ?? 10.00,
                'next_due_date' => now()->addMonth(),
                'status' => 'active',
                'created_at' => now(),
                'updated_at' => now(),
            ]);

            $this->command->info('Test service created for user: ' . $user->email);
        } else {
            $this->command->warn('No user or product found. Please run UserSeeder/ProductSeeder first.');
        }
    }
}
