@extends('layouts.admin')

@section('content')
    <div class="mb-6">
        <a href="{{ route('admin.products.index') }}"
            class="text-gray-500 hover:text-gray-700 text-sm mb-2 inline-block">&larr; Back to Products</a>
        <h1 class="text-2xl font-bold text-gray-800">Edit Product: {{ $product->name }}</h1>
    </div>

    <div class="bg-white rounded-xl shadow-sm border border-gray-100 p-6 max-w-2xl">
        <form action="{{ route('admin.products.update', $product->id) }}" method="POST">
            @csrf
            @method('PUT')

            <div class="mb-4">
                <label for="name" class="block text-sm font-medium text-gray-700 mb-1">Product Name</label>
                <input type="text" name="name" id="name" value="{{ $product->name }}"
                    class="w-full border-gray-300 rounded-md shadow-sm focus:ring-indigo-500 focus:border-indigo-500"
                    required>
            </div>

            <div class="grid grid-cols-2 gap-4 mb-4">
                <div>
                    <label for="monthly_price" class="block text-sm font-medium text-gray-700 mb-1">Monthly Price
                        (₹)</label>
                    <input type="number" step="0.01" name="monthly_price" id="monthly_price"
                        value="{{ $product->monthly_price }}"
                        class="w-full border-gray-300 rounded-md shadow-sm focus:ring-indigo-500 focus:border-indigo-500"
                        required>
                </div>
                <div>
                    <label for="whm_package_name" class="block text-sm font-medium text-gray-700 mb-1">WHM Package
                        Name</label>
                    <input type="text" name="whm_package_name" id="whm_package_name"
                        value="{{ $product->whm_package_name }}"
                        class="w-full border-gray-300 rounded-md shadow-sm focus:ring-indigo-500 focus:border-indigo-500"
                        placeholder="e.g., plan_basic" required>
                    <p class="text-xs text-gray-500 mt-1">Must match exactly in WHM.</p>
                </div>
            </div>

            <div class="mb-4">
                <label for="description" class="block text-sm font-medium text-gray-700 mb-1">Description</label>
                <textarea name="description" id="description" rows="3"
                    class="w-full border-gray-300 rounded-md shadow-sm focus:ring-indigo-500 focus:border-indigo-500">{{ $product->description }}</textarea>
            </div>

            <div class="mb-6">
                <label class="flex items-center">
                    <input type="checkbox" name="is_hidden" value="1" {{ $product->is_hidden ? 'checked' : '' }}
                        class="rounded border-gray-300 text-indigo-600 shadow-sm focus:ring-indigo-500">
                    <span class="ml-2 text-sm text-gray-600">Hide from public order page</span>
                </label>
            </div>

            <div class="flex justify-end space-x-3">
                <a href="{{ route('admin.products.index') }}"
                    class="bg-gray-100 text-gray-700 px-6 py-2 rounded-md hover:bg-gray-200 font-medium">Cancel</a>
                <button type="submit"
                    class="bg-indigo-600 text-white px-6 py-2 rounded-md hover:bg-indigo-700 font-medium">Update
                    Product</button>
            </div>
        </form>
    </div>
@endsection