@extends('layouts.client')

@section('content')
    <div class="max-w-3xl mx-auto">
        <div class="bg-white rounded-xl shadow-lg overflow-hidden">
            <div class="p-8 border-b border-gray-100 bg-gradient-to-r from-indigo-600 to-purple-600">
                <h1 class="text-2xl font-bold text-white mb-2">Checkout</h1>
                <p class="text-indigo-100">Complete your payment to activate your service.</p>
            </div>

            <div class="p-8">
                <div class="mb-8">
                    <h2 class="text-lg font-bold text-gray-800 mb-4">Order Summary</h2>
                    <div class="bg-gray-50 rounded-lg p-6 border border-gray-100">
                        <table class="w-full">
                            <tbody class="divide-y divide-gray-200">
                                <tr>
                                    <td class="py-4 text-gray-600">Description</td>
                                    <td class="py-4 text-right font-medium text-gray-900">{{ $description }}</td>
                                </tr>
                                <tr>
                                    <td class="py-4 text-gray-600">Amount</td>
                                    <td class="py-4 text-right font-medium text-gray-900">₹{{ number_format($amount, 2) }}
                                    </td>
                                </tr>
                                <tr class="text-lg font-bold text-gray-900">
                                    <td class="py-4 pt-6">Total Payable</td>
                                    <td class="py-4 pt-6 text-right">₹{{ number_format($amount, 2) }}</td>
                                </tr>
                            </tbody>
                        </table>
                    </div>
                </div>

                <div class="flex justify-center">
                    <!-- Razorpay Button -->
                    <button id="rzp-button1"
                        class="w-full md:w-auto bg-indigo-600 text-white font-bold py-4 px-12 rounded-lg hover:bg-indigo-700 transition duration-300 shadow-lg transform hover:-translate-y-1 text-lg flex items-center justify-center">
                        <svg class="w-6 h-6 mr-3" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                d="M12 15v2m-6 4h12a2 2 0 002-2v-6a2 2 0 00-2-2H6a2 2 0 00-2 2v6a2 2 0 002 2zm10-10V7a4 4 0 00-8 0v4h8z">
                            </path>
                        </svg>
                        Pay Securely with Razorpay
                    </button>
                </div>

                <p class="text-center text-gray-400 text-sm mt-6 flex justify-center items-center">
                    <svg class="w-4 h-4 mr-1" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                            d="M12 15v2m-6 4h12a2 2 0 002-2v-6a2 2 0 00-2-2H6a2 2 0 00-2 2v6a2 2 0 002 2zm10-10V7a4 4 0 00-8 0v4h8z">
                        </path>
                    </svg>
                    Secure Payment Processor. Your card details are never stored.
                </p>
            </div>
        </div>
    </div>

    <form action="{{ route('client.payment.verify') }}" method="POST" id="verify-payment-form">
        @csrf
        <input type="hidden" name="razorpay_payment_id" id="razorpay_payment_id">
        <input type="hidden" name="razorpay_order_id" id="razorpay_order_id">
        <input type="hidden" name="razorpay_signature" id="razorpay_signature">
        <input type="hidden" name="invoice_id" value="{{ $invoice_id }}">
    </form>

    <script src="https://checkout.razorpay.com/v1/checkout.js"></script>
    <script>
        var options = {
            "key": "{{ config('services.razorpay.key') }}",
            "amount": "{{ $amount * 100 }}",
            "currency": "INR",
            "name": "LuckysCloud",
            "description": "{{ $description }}",
            "order_id": "{{ $orderId }}",
            "handler": function (response) {
                document.getElementById('razorpay_payment_id').value = response.razorpay_payment_id;
                document.getElementById('razorpay_order_id').value = response.razorpay_order_id;
                document.getElementById('razorpay_signature').value = response.razorpay_signature;
                document.getElementById('verify-payment-form').submit();
            },
            "prefill": {
                "name": "{{ Auth::user()->name }}",
                "email": "{{ Auth::user()->email }}",
                "contact": "{{ Auth::user()->phone ?? '' }}"
            },
            "theme": {
                "color": "#4F46E5"
            }
        };
        var rzp1 = new Razorpay(options);
        document.getElementById('rzp-button1').onclick = function (e) {
            rzp1.open();
            e.preventDefault();
        }
        // Auto open for UX
        // window.onload = function() { rzp1.open(); }; 
    </script>
@endsection