@extends('layouts.client')

@section('content')
    <div class="mb-6">
        <h1 class="text-2xl font-bold text-gray-800">My Invoices</h1>
    </div>

    <div class="bg-white rounded-xl shadow-sm border border-gray-100 overflow-hidden">
        <div class="overflow-x-auto">
            <table class="w-full text-left">
                <thead class="bg-gray-50 text-gray-500 text-xs uppercase">
                    <tr>
                        <th class="px-6 py-4">Invoice #</th>
                        <th class="px-6 py-4">Date</th>
                        <th class="px-6 py-4">Total</th>
                        <th class="px-6 py-4">Status</th>
                        <th class="px-6 py-4"></th>
                    </tr>
                </thead>
                <tbody class="divide-y divide-gray-100">
                    @forelse($invoices as $invoice)
                        <tr>
                            <td class="px-6 py-4 font-medium text-gray-900">
                                #{{ $invoice->invoice_number }}
                            </td>
                            <td class="px-6 py-4 text-gray-600">
                                {{ $invoice->created_at->format('d M, Y') }}
                            </td>
                            <td class="px-6 py-4 font-medium text-gray-900">
                                ₹{{ number_format($invoice->total, 2) }}
                            </td>
                            <td class="px-6 py-4">
                                <span class="px-3 py-1 text-xs font-semibold rounded-full 
                                        {{ $invoice->status === 'paid' ? 'bg-green-100 text-green-800' : '' }}
                                        {{ $invoice->status === 'unpaid' ? 'bg-red-100 text-red-800' : '' }}
                                        {{ $invoice->status === 'cancelled' ? 'bg-gray-100 text-gray-800' : '' }}
                                    ">
                                    {{ ucfirst($invoice->status) }}
                                </span>
                            </td>
                            <td class="px-6 py-4 text-right">
                                <a href="{{ route('client.invoices.show', $invoice->id) }}"
                                    class="bg-indigo-50 text-indigo-600 px-3 py-1 rounded-md text-sm hover:bg-indigo-100 transition font-medium">View
                                    Invoice</a>
                            </td>
                        </tr>
                    @empty
                        <tr>
                            <td colspan="5" class="px-6 py-8 text-center text-gray-500">
                                No invoices found.
                            </td>
                        </tr>
                    @endforelse
                </tbody>
            </table>
        </div>
        @if($invoices->hasPages())
            <div class="px-6 py-4 border-t border-gray-100">
                {{ $invoices->links() }}
            </div>
        @endif
    </div>
@endsection