@extends('layouts.client')

@section('content')
    <div class="mb-6 flex justify-between items-center">
        <div>
            <a href="{{ route('client.invoices.index') }}"
                class="text-gray-500 hover:text-gray-700 text-sm flex items-center mb-2">
                <svg class="w-4 h-4 mr-1" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 19l-7-7 7-7"></path>
                </svg>
                Back to Invoices
            </a>
            <h1 class="text-2xl font-bold text-gray-800">Invoice #{{ $invoice->invoice_number }}</h1>
        </div>
        <div class="space-x-2">
            <a href="{{ route('client.invoices.download', $invoice->id) }}"
                class="bg-gray-100 text-gray-700 px-4 py-2 rounded-md hover:bg-gray-200 text-sm font-semibold flex items-center inline-flex">
                <svg class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                        d="M4 16v1a3 3 0 003 3h10a3 3 0 003-3v-1m-4-4l-4 4m0 0l-4-4m4 4V4"></path>
                </svg>
                Download PDF
            </a>
            @if($invoice->status === 'unpaid')
                <form action="{{ route('client.checkout') }}" method="POST" class="inline-block">
                    @csrf
                    <input type="hidden" name="invoice_id" value="{{ $invoice->id }}">
                    <button type="submit"
                        class="bg-green-600 text-white px-6 py-2 rounded-md hover:bg-green-700 font-bold text-sm flex items-center shadow-lg transform hover:-translate-y-0.5 transition">
                        <svg class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                d="M17 9V7a2 2 0 00-2-2H5a2 2 0 00-2 2v6a2 2 0 002 2h2m2 4h10a2 2 0 002-2v-6a2 2 0 00-2-2H9a2 2 0 00-2 2v6a2 2 0 002 2zm7-5a2 2 0 11-4 0 2 2 0 014 0z">
                            </path>
                        </svg>
                        Pay Now
                    </button>
                </form>
            @endif
        </div>
    </div>

    <div class="bg-white rounded-xl shadow-lg border border-gray-100 overflow-hidden">
        <!-- Header -->
        <div class="p-8 border-b border-gray-100 bg-gray-50 flex justify-between">
            <div>
                <h2 class="text-2xl font-bold text-indigo-600 mb-2">LuckysCloud</h2>
                <div class="text-gray-500 text-sm">
                    Premium Cloud Hosting<br>
                    support@luckyscloud.com
                </div>
            </div>
            <div class="text-right">
                <div class="uppercase text-xs text-gray-400 font-bold tracking-wider mb-1">Invoice Info</div>
                <div class="font-medium text-gray-800">Date: {{ $invoice->created_at->format('d M, Y') }}</div>
                <div class="font-medium text-gray-800">Due Date:
                    {{ $invoice->due_date ? $invoice->due_date->format('d M, Y') : '-' }}</div>
                <div class="mt-2">
                    <span class="px-3 py-1 text-xs font-bold uppercase rounded-full 
                            {{ $invoice->status === 'paid' ? 'bg-green-100 text-green-700' : '' }}
                            {{ $invoice->status === 'unpaid' ? 'bg-red-100 text-red-700' : '' }}
                            {{ $invoice->status === 'cancelled' ? 'bg-gray-100 text-gray-700' : '' }}
                        ">
                        {{ $invoice->status }}
                    </span>
                </div>
            </div>
        </div>

        <!-- Items -->
        <div class="p-0">
            <table class="w-full text-left">
                <thead class="bg-gray-50 text-gray-500 text-xs uppercase border-b border-gray-100">
                    <tr>
                        <th class="px-8 py-4">Description</th>
                        <th class="px-8 py-4 text-right">Amount</th>
                    </tr>
                </thead>
                <tbody class="divide-y divide-gray-100">
                    @foreach($invoice->items as $item)
                        <tr>
                            <td class="px-8 py-4">
                                <div class="text-gray-800 font-medium">{{ $item->description }}</div>
                            </td>
                            <td class="px-8 py-4 text-right font-medium text-gray-900">
                                ₹{{ number_format($item->amount, 2) }}
                            </td>
                        </tr>
                    @endforeach
                </tbody>
            </table>
        </div>

        <!-- Totals -->
        <div class="px-8 py-6 bg-gray-50 border-t border-gray-100">
            <div class="flex justify-end">
                <div class="w-64 space-y-3">
                    <div class="flex justify-between text-gray-600">
                        <span>Subtotal</span>
                        <span>₹{{ number_format($invoice->subtotal, 2) }}</span>
                    </div>
                    <div class="flex justify-between text-gray-600">
                        <span>Tax ({{ $invoice->tax_rate }}%)</span>
                        <span>₹{{ number_format($invoice->tax, 2) }}</span>
                    </div>
                    <div class="flex justify-between text-xl font-bold text-gray-900 border-t border-gray-200 pt-3">
                        <span>Total</span>
                        <span>₹{{ number_format($invoice->total, 2) }}</span>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection