@extends('layouts.client')

@section('content')
    <div class="flex justify-between items-center mb-6">
        <h1 class="text-2xl font-bold text-gray-800">My Services</h1>
        <a href="{{ route('client.dashboard') }}#pricing"
            class="bg-indigo-600 text-white px-4 py-2 rounded-md hover:bg-indigo-700 text-sm font-semibold">Order New
            Service</a>
    </div>

    <div class="bg-white rounded-xl shadow-sm border border-gray-100 overflow-hidden">
        <div class="overflow-x-auto">
            <table class="w-full text-left">
                <thead class="bg-gray-50 text-gray-500 text-xs uppercase">
                    <tr>
                        <th class="px-6 py-4">Product/Service</th>
                        <th class="px-6 py-4">Pricing</th>
                        <th class="px-6 py-4">Next Due Date</th>
                        <th class="px-6 py-4">Status</th>
                        <th class="px-6 py-4"></th>
                    </tr>
                </thead>
                <tbody class="divide-y divide-gray-100">
                    @forelse($services as $service)
                        <tr>
                            <td class="px-6 py-4">
                                <div class="font-bold text-indigo-600 mb-1">
                                    {{ $service->product->name ?? 'Service #' . $service->id }}</div>
                                <div class="text-sm text-gray-500">{{ $service->domain }}</div>
                            </td>
                            <td class="px-6 py-4">
                                <div class="text-gray-900 font-medium">₹{{ number_format($service->recurring_amount, 2) }}</div>
                                <div class="text-xs text-gray-500">{{ ucfirst($service->billing_cycle) }}</div>
                            </td>
                            <td class="px-6 py-4 text-sm text-gray-600">
                                {{ $service->next_due_date ? $service->next_due_date->format('d M, Y') : '-' }}
                            </td>
                            <td class="px-6 py-4">
                                <span class="px-3 py-1 text-xs font-semibold rounded-full 
                                        {{ $service->status === 'active' ? 'bg-green-100 text-green-800' : '' }}
                                        {{ $service->status === 'pending' ? 'bg-yellow-100 text-yellow-800' : '' }}
                                        {{ $service->status === 'suspended' ? 'bg-red-100 text-red-800' : '' }}
                                        {{ $service->status === 'terminated' ? 'bg-gray-100 text-gray-800' : '' }}
                                    ">
                                    {{ ucfirst($service->status) }}
                                </span>
                            </td>
                            <td class="px-6 py-4 text-right">
                                <a href="{{ route('client.services.show', $service->id) }}"
                                    class="bg-white border border-gray-300 text-gray-700 px-3 py-1 rounded-md text-sm hover:bg-gray-50 hover:text-indigo-600 transition">Manage</a>
                            </td>
                        </tr>
                    @empty
                        <tr>
                            <td colspan="5" class="px-6 py-8 text-center text-gray-500">
                                You don't have any active services yet.
                            </td>
                        </tr>
                    @endforelse
                </tbody>
            </table>
        </div>
        @if($services->hasPages())
            <div class="px-6 py-4 border-t border-gray-100">
                {{ $services->links() }}
            </div>
        @endif
    </div>
@endsection