@extends('layouts.client')

@section('content')
    <div class="mb-6 flex justify-between items-center">
        <div>
            <a href="{{ route('client.services.index') }}"
                class="text-gray-500 hover:text-gray-700 text-sm flex items-center mb-2">
                <svg class="w-4 h-4 mr-1" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 19l-7-7 7-7"></path>
                </svg>
                Back to Services
            </a>
            <h1 class="text-2xl font-bold text-gray-800">Manage Service</h1>
        </div>

        @if($service->status === 'active')
            <a href="https://{{ $service->server->hostname }}:2083/login/?user={{ $service->username }}&pass={{ $service->password }}"
                target="_blank"
                class="bg-indigo-600 text-white px-6 py-2 rounded-md hover:bg-indigo-700 font-bold flex items-center">
                <svg class="w-5 h-5 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                        d="M10 6H6a2 2 0 00-2 2v10a2 2 0 002 2h10a2 2 0 002-2v-4M14 4h6m0 0v6m0-6L10 14"></path>
                </svg>
                Login to cPanel
            </a>
        @endif
    </div>

    <div class="grid grid-cols-1 lg:grid-cols-3 gap-8">
        <!-- Main Info -->
        <div class="lg:col-span-2 space-y-6">
            <div class="bg-white rounded-xl shadow-sm border border-gray-100 p-6">
                <h2 class="text-lg font-bold text-gray-800 mb-4 border-b border-gray-100 pb-2">Hosting Information</h2>
                <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                    <div>
                        <p class="text-sm text-gray-500 mb-1">Domain</p>
                        <p class="font-medium text-gray-900"><a href="http://{{ $service->domain }}" target="_blank"
                                class="text-indigo-600 hover:underline">{{ $service->domain }}</a></p>
                    </div>
                    <div>
                        <p class="text-sm text-gray-500 mb-1">Server Name</p>
                        <p class="font-medium text-gray-900">{{ $service->server->name }}</p>
                    </div>
                    <div>
                        <p class="text-sm text-gray-500 mb-1">IP Address</p>
                        <p class="font-medium text-gray-900">{{ $service->server->ip_address }}</p>
                    </div>
                    <div>
                        <p class="text-sm text-gray-500 mb-1">Status</p>
                        <span class="px-2 py-1 text-xs font-semibold rounded-full 
                                {{ $service->status === 'active' ? 'bg-green-100 text-green-800' : '' }}
                                {{ $service->status === 'pending' ? 'bg-yellow-100 text-yellow-800' : '' }}
                                {{ $service->status === 'suspended' ? 'bg-red-100 text-red-800' : '' }}
                            ">
                            {{ ucfirst($service->status) }}
                        </span>
                    </div>
                </div>
            </div>

            <div class="bg-white rounded-xl shadow-sm border border-gray-100 p-6" x-data="{ showPass: false }">
                <h2 class="text-lg font-bold text-gray-800 mb-4 border-b border-gray-100 pb-2">Login Credentials</h2>
                <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                    <div>
                        <p class="text-sm text-gray-500 mb-1">Username</p>
                        <p class="font-mono bg-gray-50 p-2 rounded text-gray-700">{{ $service->username }}</p>
                    </div>
                    <div>
                        <p class="text-sm text-gray-500 mb-1">Password</p>
                        <div class="flex">
                            <input type="text" :type="showPass ? 'text' : 'password'" value="{{ $service->password }}"
                                readonly
                                class="font-mono bg-gray-50 p-2 rounded text-gray-700 w-full border-0 focus:ring-0">
                            <button @click="showPass = !showPass" class="ml-2 text-gray-500 hover:text-indigo-600">
                                <svg x-show="!showPass" class="w-5 h-5" fill="none" stroke="currentColor"
                                    viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                        d="M15 12a3 3 0 11-6 0 3 3 0 016 0z"></path>
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                        d="M2.458 12C3.732 7.943 7.523 5 12 5c4.478 0 8.268 2.943 9.542 7-1.274 4.057-5.064 7-9.542 7-4.477 0-8.268-2.943-9.542-7z">
                                    </path>
                                </svg>
                                <svg x-show="showPass" class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24"
                                    style="display: none;">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                        d="M13.875 18.825A10.05 10.05 0 0112 19c-4.478 0-8.268-2.943-9.542-7a10.05 10.05 0 011.574-2.59M5.753 5.753l12.494 12.494">
                                    </path>
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                        d="M17.828 17.828A9.936 9.936 0 0021.542 12C20.268 7.943 16.477 5 12 5c-.9 0-1.775.119-2.618.338m-3.666 1.706A9.972 9.972 0 002.458 12">
                                    </path>
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                        d="M9.88 9.88a3 3 0 104.24 4.24"></path>
                                </svg>
                            </button>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Sidebar Info -->
        <div class="space-y-6">
            <div class="bg-white rounded-xl shadow-sm border border-gray-100 p-6">
                <h2 class="text-lg font-bold text-gray-800 mb-4 border-b border-gray-100 pb-2">Billing Details</h2>
                <ul class="space-y-4">
                    <li class="flex justify-between">
                        <span class="text-gray-500">Recurring Amount</span>
                        <span class="font-bold text-gray-900">₹{{ number_format($service->recurring_amount, 2) }}</span>
                    </li>
                    <li class="flex justify-between">
                        <span class="text-gray-500">Billing Cycle</span>
                        <span class="font-medium">{{ ucfirst($service->billing_cycle) }}</span>
                    </li>
                    <li class="flex justify-between">
                        <span class="text-gray-500">Next Due Date</span>
                        <span
                            class="font-medium">{{ $service->next_due_date ? $service->next_due_date->format('d M, Y') : '-' }}</span>
                    </li>
                    <li class="flex justify-between">
                        <span class="text-gray-500">Reg. Date</span>
                        <span class="font-medium">{{ $service->created_at->format('d M, Y') }}</span>
                    </li>
                </ul>
            </div>

            <!-- Quick Actions -->
            <div class="bg-white rounded-xl shadow-sm border border-gray-100 p-6">
                <h2 class="text-lg font-bold text-gray-800 mb-4 border-b border-gray-100 pb-2">Quick Actions</h2>
                <div class="space-y-3">
                    <a href="https://{{ $service->server->hostname }}:2096" target="_blank"
                        class="block w-full text-center border border-gray-300 text-gray-700 py-2 rounded hover:bg-gray-50 transition">Webmail
                        Login</a>
                    <a href="#"
                        class="block w-full text-center border border-red-200 text-red-600 py-2 rounded hover:bg-red-50 transition">Request
                        Cancellation</a>
                </div>
            </div>
        </div>
    </div>
@endsection