@extends('layouts.installer')

@section('content')
    <div class="mb-4">
        <h4>Admin Account Setup</h4>
        <p class="text-muted">Create the main administrator account for your panel.</p>
    </div>

    <form action="{{ route('installer.admin.save') }}" method="POST">
        @csrf

        <div class="mb-3">
            <label for="name" class="form-label">Full Name</label>
            <input type="text" name="name" id="name" class="form-control" placeholder="John Doe" required>
        </div>

        <div class="mb-3">
            <label for="email" class="form-label">Email Address</label>
            <input type="email" name="email" id="email" class="form-control" placeholder="admin@example.com" required>
        </div>

        <div class="row mb-4">
            <div class="col-md-6">
                <label for="password" class="form-label">Password</label>
                <input type="password" name="password" id="password" class="form-control" required>
            </div>
            <div class="col-md-6">
                <label for="password_confirmation" class="form-label">Confirm Password</label>
                <input type="password" name="password_confirmation" id="password_confirmation" class="form-control"
                    required>
            </div>
        </div>

        <div class="d-flex justify-content-between">
            <a href="{{ route('installer.app') }}" class="btn btn-outline-secondary"><i class="fas fa-arrow-left me-2"></i>
                Back</a>
            <button type="submit" class="btn btn-primary px-4">Create Account & Install <i
                    class="fas fa-arrow-right ms-2"></i></button>
        </div>
    </form>
@endsection