@extends('layouts.installer')

@section('content')
    <div class="mb-4">
        <h4>Application Setup</h4>
        <p class="text-muted">Configure the basic settings for your panel.</p>
    </div>

    <form action="{{ route('installer.app.save') }}" method="POST">
        @csrf

        <div class="mb-3">
            <label for="app_name" class="form-label">Application Name</label>
            <input type="text" name="app_name" id="app_name" class="form-control" value="LuckysCloud Panel" required>
        </div>

        <div class="mb-4">
            <label for="app_url" class="form-label">Application URL</label>
            <input type="url" name="app_url" id="app_url" class="form-control"
                value="{{ request()->getSchemeAndHttpHost() }}" required>
            <small class="text-muted">The URL where this panel is installed.</small>
        </div>

        <div class="d-flex justify-content-between">
            <a href="{{ route('installer.database') }}" class="btn btn-outline-secondary"><i
                    class="fas fa-arrow-left me-2"></i> Back</a>
            <button type="submit" class="btn btn-primary px-4">Save & Continue <i
                    class="fas fa-arrow-right ms-2"></i></button>
        </div>
    </form>
@endsection