@extends('layouts.installer')

@section('content')
    <div class="mb-4">
        <h4>Database Configuration</h4>
        <p class="text-muted">Enter your database connection details.</p>
    </div>

    <form action="{{ route('installer.database.save') }}" method="POST">
        @csrf

        <div class="row mb-3">
            <div class="col-md-8">
                <label for="host" class="form-label">Database Host</label>
                <input type="text" name="host" id="host" class="form-control" value="127.0.0.1" required>
            </div>
            <div class="col-md-4">
                <label for="port" class="form-label">Port</label>
                <input type="text" name="port" id="port" class="form-control" value="3306" required>
            </div>
        </div>

        <div class="mb-3">
            <label for="database" class="form-label">Database Name</label>
            <input type="text" name="database" id="database" class="form-control" value="luckyscloud_panel" required>
        </div>

        <div class="mb-3">
            <label for="username" class="form-label">Username</label>
            <input type="text" name="username" id="username" class="form-control" value="root" required>
        </div>

        <div class="mb-4">
            <label for="password" class="form-label">Password</label>
            <input type="password" name="password" id="password" class="form-control" placeholder="Database Password">
        </div>

        <div class="d-flex justify-content-between">
            <div class="text-muted small align-self-center"><i class="fas fa-info-circle me-1"></i> We will test the
                connection before saving.</div>
            <button type="submit" class="btn btn-primary px-4">Save & Continue <i
                    class="fas fa-arrow-right ms-2"></i></button>
        </div>
    </form>
@endsection