@extends('layouts.installer')

@section('content')
    <div class="text-center py-5">
        <div class="mb-4">
            <i class="fas fa-check-circle fa-5x text-success"></i>
        </div>
        <h2 class="mb-3">Installation Successful!</h2>
        <p class="text-muted mb-5">
            LuckysCloud Panel has been installed and configured.
        </p>

        <div class="d-grid gap-2 col-md-6 mx-auto mb-5">
            <a href="{{ url('/') }}" class="btn btn-primary btn-lg">Go to Homepage</a>
            <a href="{{ url('/admin/dashboard') }}" class="btn btn-outline-dark">Login to Admin Panel</a>
        </div>

        <div class="alert alert-warning text-start mb-5">
            <h5><i class="fas fa-shield-alt me-2"></i> Security Notice</h5>
            <p class="mb-0">
                The installer has been locked (<code>storage/installed.lock</code> created).<br>
                For extra security, you may delete the <code>app/Http/Controllers/InstallerController.php</code> file and
                the <code>/install</code> routes.
            </p>
        </div>

        <div class="card text-start bg-light border-0">
            <div class="card-body">
                <h5 class="card-title"><i class="fas fa-cogs me-2"></i> Set up Automation</h5>
                <p class="card-text">Add the following Cron Job to your server (run every minute):</p>
                <code class="d-block bg-dark text-white p-3 rounded mb-3">
                        * * * * * php {{ base_path('artisan') }} schedule:run >> /dev/null 2>&1
                    </code>

                <p class="card-text">Run the Queue Worker (via Supervisor):</p>
                <code class="d-block bg-dark text-white p-3 rounded">
                        php {{ base_path('artisan') }} queue:work database --sleep=3 --tries=3
                    </code>
            </div>
        </div>
    </div>
@endsection