@extends('layouts.installer')

@section('content')
    <div class="mb-4">
        <h4>License Verification</h4>
        <p class="text-muted">Please enter your purchase code to verify your license.</p>
    </div>

    <form action="{{ route('installer.license.verify') }}" method="POST">
        @csrf

        <div class="mb-3">
            <label for="username" class="form-label">Envato Username / Client Name</label>
            <input type="text" name="username" id="username" class="form-control" value="{{ old('username') }}" required>
        </div>

        <div class="mb-4">
            <label for="purchase_code" class="form-label">Purchase Code</label>
            <input type="text" name="purchase_code" id="purchase_code" class="form-control"
                value="{{ old('purchase_code') }}" placeholder="xxxx-xxxx-xxxx-xxxx" required>
            <div class="form-text">Your license key from the purchase.</div>
        </div>

        <div class="d-flex justify-content-between">
            <a href="{{ route('installer.requirements') }}" class="btn btn-outline-secondary"><i
                    class="fas fa-arrow-left me-2"></i> Back</a>
            <button type="submit" class="btn btn-primary px-4">Verify License <i
                    class="fas fa-arrow-right ms-2"></i></button>
        </div>
    </form>
@endsection