@extends('layouts.installer')

@section('content')
    <div class="text-center py-5">
        <div class="mb-4">
            <div class="spinner-border text-primary" role="status" style="width: 4rem; height: 4rem;">
                <span class="visually-hidden">Loading...</span>
            </div>
        </div>
        <h3 class="mb-3">Installing LuckysCloud Panel...</h3>
        <p class="text-muted mb-5" id="status-text">
            Please wait while we configure your system.<br>
            This usually takes less than a minute. Do not close this tab.
        </p>

        <div id="error-box" class="alert alert-danger d-none text-start">
            <h5><i class="fas fa-exclamation-triangle me-2"></i> Installation Failed</h5>
            <p id="error-message"></p>
            <a href="{{ route('installer.admin') }}" class="btn btn-sm btn-outline-danger">Try Again</a>
        </div>
    </div>

    <script>
        document.addEventListener('DOMContentLoaded', function () {
            const statusText = document.getElementById('status-text');
            const errorBox = document.getElementById('error-box');
            const errorMessage = document.getElementById('error-message');

            fetch("{{ route('installer.process') }}", {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json',
                    'X-CSRF-TOKEN': "{{ csrf_token() }}"
                },
                body: JSON.stringify({})
            })
                .then(response => response.json())
                .then(data => {
                    if (data.status === 'success') {
                        statusText.innerHTML = '<i class="fas fa-check-circle text-success me-2"></i> Installation Complete! Redirecting...';
                        setTimeout(() => {
                            window.location.href = data.redirect;
                        }, 1000);
                    } else {
                        throw new Error(data.message || 'Unknown error occurred');
                    }
                })
                .catch(error => {
                    document.querySelector('.spinner-border').classList.add('d-none');
                    statusText.classList.add('d-none');
                    errorBox.classList.remove('d-none');
                    errorMessage.textContent = error.message;
                });
        });
    </script>
@endsection