@extends('layouts.installer')

@section('content')
    <div class="mb-4">
        <h4>Server Requirements</h4>
        <p class="text-muted">Checking if your server meets the requirements to run LuckysCloud.</p>
    </div>

    <div class="card mb-4">
        <div class="card-header bg-white">PHP Version</div>
        <div class="card-body p-0">
            <ul class="list-group list-group-flush">
                <li class="list-group-item d-flex justify-content-between align-items-center">
                    <span>PHP Version >= {{ $requirements['php']['version'] }} (Current:
                        {{ $requirements['php']['current'] }})</span>
                    @if($requirements['php']['status'])
                        <span class="badge bg-success"><i class="fas fa-check"></i></span>
                    @else
                        <span class="badge bg-danger"><i class="fas fa-times"></i></span>
                    @endif
                </li>
            </ul>
        </div>
    </div>

    <div class="card mb-4">
        <div class="card-header bg-white">PHP Extensions</div>
        <div class="card-body p-0">
            <ul class="list-group list-group-flush">
                @foreach($requirements['extensions'] as $ext => $enabled)
                    <li class="list-group-item d-flex justify-content-between align-items-center">
                        <span>{{ strtoupper($ext) }}</span>
                        @if($enabled)
                            <span class="badge bg-success"><i class="fas fa-check"></i></span>
                        @else
                            <span class="badge bg-danger"><i class="fas fa-times"></i></span>
                        @endif
                    </li>
                @endforeach
            </ul>
        </div>
    </div>

    <div class="card mb-4">
        <div class="card-header bg-white">Permissions</div>
        <div class="card-body p-0">
            <ul class="list-group list-group-flush">
                @foreach($requirements['permissions'] as $path => $writable)
                    <li class="list-group-item d-flex justify-content-between align-items-center">
                        <span>{{ $path }} (Writable)</span>
                        @if($writable)
                            <span class="badge bg-success"><i class="fas fa-check"></i></span>
                        @else
                            <span class="badge bg-danger"><i class="fas fa-times"></i></span>
                        @endif
                    </li>
                @endforeach
            </ul>
        </div>
    </div>

    <div class="text-end">
        @if($allMet)
            <a href="{{ route('installer.license') }}" class="btn btn-primary px-4">Continue <i
                    class="fas fa-arrow-right ms-2"></i></a>
        @else
            <button class="btn btn-danger px-4" disabled>Please fix errors to continue</button>
            <a href="{{ route('installer.requirements') }}" class="btn btn-secondary ms-2"><i class="fas fa-sync me-2"></i>
                Refresh</a>
        @endif
    </div>
@endsection