<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Installer - LuckysCloud Panel</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <style>
        body {
            background-color: #f3f4f6;
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
        }

        .installer-container {
            max_width: 900px;
            margin: 50px auto;
            background: #fff;
            border-radius: 12px;
            box-shadow: 0 10px 25px rgba(0, 0, 0, 0.05);
            overflow: hidden;
        }

        .sidebar {
            background: #1e1b4b;
            color: rgba(255, 255, 255, 0.7);
            min-height: 500px;
            padding: 40px 30px;
        }

        .sidebar h3 {
            color: #fff;
            font-weight: 700;
            margin-bottom: 30px;
        }

        .step {
            display: flex;
            align-items: center;
            margin-bottom: 20px;
        }

        .step-icon {
            width: 32px;
            height: 32px;
            border-radius: 50%;
            border: 2px solid rgba(255, 255, 255, 0.2);
            display: flex;
            align-items: center;
            justify-content: center;
            margin-right: 15px;
            font-weight: 600;
            font-size: 14px;
        }

        .step.active .step-icon {
            background: #4f46e5;
            border-color: #4f46e5;
            color: #fff;
        }

        .step.active .step-text {
            color: #fff;
            font-weight: 600;
        }

        .step.completed .step-icon {
            background: #10b981;
            border-color: #10b981;
            color: #fff;
        }

        .content {
            padding: 40px;
        }

        .btn-primary {
            background-color: #4f46e5;
            border-color: #4f46e5;
            padding: 10px 25px;
            font-weight: 600;
        }

        .btn-primary:hover {
            background-color: #4338ca;
            border-color: #4338ca;
        }

        .form-control:focus {
            border-color: #4f46e5;
            box-shadow: 0 0 0 0.25rem rgba(79, 70, 229, 0.25);
        }
    </style>
</head>

<body>

    <div class="installer-container">
        <div class="row g-0">
            <div class="col-md-4 sidebar">
                <h3>LuckysCloud</h3>
                <div class="d-flex flex-column">
                    <div class="step {{ request()->routeIs('installer.welcome') ? 'active' : 'completed' }}">
                        <div class="step-icon"><i class="fas fa-home"></i></div>
                        <div class="step-text">Welcome</div>
                    </div>
                    <div
                        class="step {{ request()->routeIs('installer.requirements') ? 'active' : (request()->routeIs('installer.welcome') ? '' : 'completed') }}">
                        <div class="step-icon"><i class="fas fa-server"></i></div>
                        <div class="step-text">Requirements</div>
                    </div>
                    <div
                        class="step {{ request()->routeIs('installer.license') ? 'active' : (request()->routeIs('installer.welcome') || request()->routeIs('installer.requirements') ? '' : 'completed') }}">
                        <div class="step-icon"><i class="fas fa-key"></i></div>
                        <div class="step-text">License</div>
                    </div>
                    <div
                        class="step {{ request()->routeIs('installer.database') ? 'active' : (request()->routeIs('installer.app') || request()->routeIs('installer.admin') || request()->routeIs('installer.finish') ? 'completed' : '') }}">
                        <div class="step-icon"><i class="fas fa-database"></i></div>
                        <div class="step-text">Database</div>
                    </div>
                    <div
                        class="step {{ request()->routeIs('installer.app') ? 'active' : (request()->routeIs('installer.admin') || request()->routeIs('installer.finish') ? 'completed' : '') }}">
                        <div class="step-icon"><i class="fas fa-cogs"></i></div>
                        <div class="step-text">App Setup</div>
                    </div>
                    <div
                        class="step {{ request()->routeIs('installer.admin') ? 'active' : (request()->routeIs('installer.finish') ? 'completed' : '') }}">
                        <div class="step-icon"><i class="fas fa-user-shield"></i></div>
                        <div class="step-text">Admin Account</div>
                    </div>
                    <div class="step {{ request()->routeIs('installer.finish') ? 'active' : '' }}">
                        <div class="step-icon"><i class="fas fa-check"></i></div>
                        <div class="step-text">Finish</div>
                    </div>
                </div>
            </div>
            <div class="col-md-8 content">
                @if(session('error'))
                    <div class="alert alert-danger mb-4">{{ session('error') }}</div>
                @endif
                @if($errors->any())
                    <div class="alert alert-danger mb-4">
                        <ul class="mb-0 ps-3">
                            @foreach($errors->all() as $error)
                                <li>{{ $error }}</li>
                            @endforeach
                        </ul>
                    </div>
                @endif

                @yield('content')
            </div>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>

</html>