<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>{{ config('app.name', 'LuckysCloud') }} - Premium Hosting</title>

    <!-- Fonts -->
    <link rel="preconnect" href="https://fonts.bunny.net">
    <link href="https://fonts.bunny.net/css?family=figtree:400,500,600&display=swap" rel="stylesheet" />

    <!-- Scripts -->
    @vite(['resources/css/app.css', 'resources/js/app.js'])
</head>

<body class="antialiased bg-gray-50 text-gray-900 font-sans">

    <!-- Navigation -->
    <nav class="bg-white shadow-sm fixed w-full z-50">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <div class="flex justify-between h-16">
                <div class="flex items-center">
                    <a href="/" class="text-2xl font-bold text-indigo-600">LuckysCloud</a>
                </div>
                <div class="hidden sm:flex items-center space-x-8">
                    <a href="#features" class="text-gray-600 hover:text-indigo-600">Features</a>
                    <a href="#pricing" class="text-gray-600 hover:text-indigo-600">Pricing</a>

                    @if (Route::has('login'))
                        @auth
                            <a href="{{ route('client.dashboard') }}" class="text-indigo-600 font-semibold">Client Area</a>
                        @else
                            <a href="{{ route('login') }}" class="text-gray-600 hover:text-indigo-600">Login</a>
                            @if (Route::has('register'))
                                <a href="{{ route('register') }}"
                                    class="bg-indigo-600 text-white px-4 py-2 rounded-md hover:bg-indigo-700">Get Started</a>
                            @endif
                        @endauth
                    @endif
                </div>
            </div>
        </div>
    </nav>

    <!-- Hero Section -->
    <section class="pt-32 pb-20 bg-gradient-to-r from-indigo-600 to-purple-600 text-white text-center">
        <div class="max-w-7xl mx-auto px-4">
            <h1 class="text-5xl font-bold mb-6">High Performance Cloud Hosting</h1>
            <p class="text-xl mb-10 text-indigo-100">Deploy your apps in seconds with our cPanel-powered cloud
                infrastructure.</p>
            <a href="#pricing"
                class="bg-white text-indigo-600 px-8 py-3 rounded-full font-bold text-lg hover:bg-gray-100 transition">View
                Plans</a>
        </div>
    </section>

    <!-- Features -->
    <section id="features" class="py-20">
        <div class="max-w-7xl mx-auto px-4">
            <h2 class="text-3xl font-bold text-center mb-12">Why Choose Us?</h2>
            <div class="grid md:grid-cols-3 gap-8">
                <div class="bg-white p-8 rounded-xl shadow-lg hover:-translate-y-1 transition duration-300">
                    <div class="text-indigo-600 mb-4 items-center justify-center flex">
                        <!-- Icon Placeholder -->
                        <svg class="w-12 h-12" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                d="M13 10V3L4 14h7v7l9-11h-7z"></path>
                        </svg>
                    </div>
                    <h3 class="text-xl font-bold mb-2">Blazing Fast Speed</h3>
                    <p class="text-gray-600">Powered by NVMe SSDs and LiteSpeed Web Server for maximum performance.</p>
                </div>
                <div class="bg-white p-8 rounded-xl shadow-lg hover:-translate-y-1 transition duration-300">
                    <div class="text-indigo-600 mb-4 items-center justify-center flex">
                        <svg class="w-12 h-12" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                d="M12 15v2m-6 4h12a2 2 0 002-2v-6a2 2 0 00-2-2H6a2 2 0 00-2 2v6a2 2 0 002 2zm10-10V7a4 4 0 00-8 0v4h8z">
                            </path>
                        </svg>
                    </div>
                    <h3 class="text-xl font-bold mb-2">Secure & Reliable</h3>
                    <p class="text-gray-600">Free SSL, Daily Backups, and Imunify360 protection included.</p>
                </div>
                <div class="bg-white p-8 rounded-xl shadow-lg hover:-translate-y-1 transition duration-300">
                    <div class="text-indigo-600 mb-4 items-center justify-center flex">
                        <svg class="w-12 h-12" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                d="M18.364 5.636l-3.536 3.536m0 5.656l3.536 3.536M9.172 9.172L5.636 5.636m3.536 9.192l-3.536 3.536M21 12a9 9 0 11-18 0 9 9 0 0118 0zm-5 0a4 4 0 11-8 0 4 4 0 018 0z">
                            </path>
                        </svg>
                    </div>
                    <h3 class="text-xl font-bold mb-2">24/7 Support</h3>
                    <p class="text-gray-600">Our expert team is always here to help you via ticket or live chat.</p>
                </div>
            </div>
        </div>
    </section>

    <!-- Pricing -->
    <section id="pricing" class="py-20 bg-gray-100">
        <div class="max-w-7xl mx-auto px-4">
            <h2 class="text-3xl font-bold text-center mb-12">Hosting Plans</h2>
            <div class="grid md:grid-cols-3 gap-8">
                <!-- Fetch from DB or Static for now -->
                @php
                    $plans = \App\Models\Product::where('is_hidden', false)->orderBy('sort_order')->get();
                @endphp

                @forelse($plans as $plan)
                    <div class="bg-white p-8 rounded-xl shadow-lg border-t-4 border-indigo-600 relative overflow-hidden">
                        <h3 class="text-2xl font-bold mb-4">{{ $plan->name }}</h3>
                        <div class="text-4xl font-bold mb-6 text-gray-800">
                            ₹{{ number_format($plan->monthly_price, 0) }}<span
                                class="text-lg text-gray-500 font-normal">/mo</span>
                        </div>
                        <p class="text-gray-600 mb-6">{{ $plan->description }}</p>
                        <ul class="mb-8 space-y-3 text-gray-600">
                            <li class="flex items-center"><svg class="w-5 h-5 text-green-500 mr-2" fill="none"
                                    stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                        d="M5 13l4 4L19 7"></path>
                                </svg> cPanel Control Panel</li>
                            <li class="flex items-center"><svg class="w-5 h-5 text-green-500 mr-2" fill="none"
                                    stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                        d="M5 13l4 4L19 7"></path>
                                </svg> NVMe SSD Storage</li>
                            <li class="flex items-center"><svg class="w-5 h-5 text-green-500 mr-2" fill="none"
                                    stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                        d="M5 13l4 4L19 7"></path>
                                </svg> Unlimited Bandwidth</li>
                        </ul>

                        <form action="{{ route('client.checkout') }}" method="POST">
                            @csrf
                            <input type="hidden" name="product_id" value="{{ $plan->id }}">
                            <button type="submit"
                                class="w-full block text-center bg-indigo-600 text-white py-3 rounded-lg font-bold hover:bg-indigo-700 transition">Order
                                Now</button>
                        </form>
                    </div>
                @empty
                    <div class="col-span-3 text-center text-gray-500">
                        <p>No plans available at the moment.</p>
                    </div>
                @endforelse
            </div>
        </div>
    </section>

    <!-- Footer -->
    <footer class="bg-gray-900 text-gray-400 py-12">
        <div class="max-w-7xl mx-auto px-4 text-center">
            <p>&copy; {{ date('Y') }} LuckysCloud. All rights reserved.</p>
        </div>
    </footer>

</body>

</html>