<?php

use App\Http\Controllers\ProfileController;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Admin\ProductController;
use App\Http\Controllers\Client\DashboardController;
use App\Http\Controllers\Client\InvoiceController;
use App\Http\Controllers\Client\OrderController;
use App\Http\Controllers\RazorpayWebhookController;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
*/

Route::get('/', function () {
    return view('welcome');
});

// Dashboard redirection
Route::get('/dashboard', function () {
    return redirect()->route('client.dashboard');
})->middleware(['auth', 'verified'])->name('dashboard');

// Profile Routes (Breeze)
Route::middleware('auth')->group(function () {
    Route::get('/profile', [ProfileController::class, 'edit'])->name('profile.edit');
    Route::patch('/profile', [ProfileController::class, 'update'])->name('profile.update');
    Route::delete('/profile', [ProfileController::class, 'destroy'])->name('profile.destroy');
});

// Authentication Routes
require __DIR__ . '/auth.php';

// Client Area
Route::middleware(['auth', 'verified'])->prefix('client')->name('client.')->group(function () {
    Route::get('/dashboard', [DashboardController::class, 'index'])->name('dashboard');

    // Services
    Route::get('/services', [DashboardController::class, 'services'])->name('services.index');
    Route::get('/services/{id}', [DashboardController::class, 'showService'])->name('services.show');

    // Invoices
    Route::get('/invoices', [InvoiceController::class, 'index'])->name('invoices.index');
    Route::get('/invoices/{id}', [InvoiceController::class, 'show'])->name('invoices.show');
    Route::get('/invoices/{id}/download', [InvoiceController::class, 'download'])->name('invoices.download');

    // Orders & Checkout
    Route::post('/checkout', [OrderController::class, 'checkout'])->name('checkout');
    Route::post('/payment/verify', [OrderController::class, 'verifyPayment'])->name('payment.verify');
});

// Admin Panel
Route::middleware(['auth'])->prefix('admin')->name('admin.')->group(function () {
    // Dashboard
    Route::get('/dashboard', function () {
        return view('admin.dashboard');
    })->name('dashboard');

    // Products
    Route::resource('products', ProductController::class);

    // Clients
    Route::get('/clients', function () {
        return view('admin.clients.index', ['clients' => \App\Models\Client::paginate(10)]);
    })->name('clients.index');

    // Orders
    Route::get('/orders', function () {
        return view('admin.orders.index', ['orders' => \App\Models\Order::latest()->paginate(10)]);
    })->name('orders.index');
});

// Webhooks
Route::post('/webhooks/razorpay', [RazorpayWebhookController::class, 'handle'])->name('webhook.razorpay');

// Installer Routes
Route::prefix('install')->name('installer.')->group(function () {
    Route::get('/', [\App\Http\Controllers\InstallerController::class, 'welcome'])->name('welcome');
    Route::get('/requirements', [\App\Http\Controllers\InstallerController::class, 'requirements'])->name('requirements');
    Route::get('/license', [\App\Http\Controllers\InstallerController::class, 'license'])->name('license');
    Route::post('/license/verify', [\App\Http\Controllers\InstallerController::class, 'verifyLicense'])->name('license.verify');
    Route::get('/database', [\App\Http\Controllers\InstallerController::class, 'database'])->name('database');
    Route::post('/database/save', [\App\Http\Controllers\InstallerController::class, 'saveDatabase'])->name('database.save');
    Route::get('/app', [\App\Http\Controllers\InstallerController::class, 'appSetup'])->name('app');
    Route::post('/app/save', [\App\Http\Controllers\InstallerController::class, 'saveApp'])->name('app.save');
    Route::get('/admin', [\App\Http\Controllers\InstallerController::class, 'adminSetup'])->name('admin');
    Route::post('/admin/save', [\App\Http\Controllers\InstallerController::class, 'saveAdmin'])->name('admin.save');
    Route::post('/process', [\App\Http\Controllers\InstallerController::class, 'install'])->name('process');
    Route::get('/finish', [\App\Http\Controllers\InstallerController::class, 'finish'])->name('finish');
});
